/*
 Erica Sadun, http://ericasadun.com
 iPhone Developer's Cookbook, 5.x Edition
 BSD License, Use at your own risk
 */

#import <UIKit/UIKit.h>

#define COOKBOOK_PURPLE_COLOR	[UIColor colorWithRed:0.20392f green:0.19607f blue:0.61176f alpha:1.0f]
#define BARBUTTON(TITLE, SELECTOR) 	[[UIBarButtonItem alloc] initWithTitle:TITLE style:UIBarButtonItemStylePlain target:self action:SELECTOR]

@interface TestBedViewController : UIViewController <UIActionSheetDelegate>
@end

@implementation TestBedViewController

- (void) actionSheetCancel:(UIActionSheet *)actionSheet
{
    NSLog(@"Anulowano");
}

- (void) actionSheet:(UIActionSheet *)actionSheet didDismissWithButtonIndex:(NSInteger)buttonIndex
{
    self.title = [NSString stringWithFormat:@"Przycisk %d", buttonIndex];
}

- (void) action: (UIBarButtonItem *) sender
{
    // Destrukcyjny = 0, Pierwszy = 1, Drugi = 2, Trzeci = 3, Anuluj = 4.
    // UIActionSheet *actionSheet = [[UIActionSheet alloc] initWithTitle:@"Tytuł" delegate:self cancelButtonTitle:@"Anuluj" destructiveButtonTitle:@"Destrukcyjny" otherButtonTitles:@"Pierwszy", @"Drugi", @"Trzeci", nil];
    
    // Long list example
    UIActionSheet *actionSheet = [[UIActionSheet alloc] initWithTitle:nil delegate:self cancelButtonTitle:@"Anuluj" destructiveButtonTitle:nil otherButtonTitles:@"Jeden", @"Dwa", @"Trzy", @"Cztery", @"Pięć", @"Sześć", @"Siedem", @"Osiem", @"Dziewięć", @"Dziesięć", @"Jedenaście", @"Dwanaście", nil];
    [actionSheet showFromBarButtonItem:sender animated:YES];
}

- (void) loadView
{
    [super loadView];
    self.view.backgroundColor = [UIColor whiteColor];
    self.navigationItem.rightBarButtonItem = BARBUTTON(@"Akcja", @selector(action:));
}

- (BOOL)shouldAutorotateToInterfaceOrientation:(UIInterfaceOrientation)interfaceOrientation
{
	return YES;
}
@end

#pragma mark -

#pragma mark Konfiguracja aplikacji
@interface TestBedAppDelegate : NSObject <UIApplicationDelegate>
{
	UIWindow *window;
}
@end
@implementation TestBedAppDelegate
- (BOOL)application:(UIApplication *)application didFinishLaunchingWithOptions:(NSDictionary *)launchOptions 
{	
    [application setStatusBarHidden:YES];
    [[UINavigationBar appearance] setTintColor:COOKBOOK_PURPLE_COLOR];
    
	window = [[UIWindow alloc] initWithFrame:[[UIScreen mainScreen] bounds]];
	TestBedViewController *tbvc = [[TestBedViewController alloc] init];
    UINavigationController *nav = [[UINavigationController alloc] initWithRootViewController:tbvc];
    window.rootViewController = nav;
	[window makeKeyAndVisible];
    return YES;
}
@end
int main(int argc, char *argv[]) {
    @autoreleasepool {
        int retVal = UIApplicationMain(argc, argv, nil, @"TestBedAppDelegate");
        return retVal;
    }
}